/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedComponentStyle;
import org.jetbrains.annotations.NotNull;

public class WrappedNumberFormat
extends AbstractWrapper {
    private static final Object BLANK;
    private static final ConstructorAccessor FIXED_CONSTRUCTOR;
    private static final ConstructorAccessor STYLED_CONSTRUCTOR;

    public static boolean isSupported() {
        return MinecraftReflection.getNumberFormatClass().isPresent();
    }

    public static WrappedNumberFormat fromHandle(Object handle) {
        WrappedNumberFormat.throwIfUnsupported();
        if (MinecraftReflection.getBlankFormatClass().get().isInstance(handle)) {
            return new Blank(handle);
        }
        if (MinecraftReflection.getFixedFormatClass().get().isInstance(handle)) {
            return new Fixed(handle);
        }
        if (MinecraftReflection.getStyledFormatClass().get().isInstance(handle)) {
            return new Styled(handle);
        }
        throw new IllegalArgumentException("handle is not a NumberFormat instance, but " + String.valueOf(handle.getClass()));
    }

    public static Blank blank() {
        WrappedNumberFormat.throwIfUnsupported();
        return new Blank(BLANK);
    }

    public static Fixed fixed(@NotNull WrappedChatComponent content) {
        WrappedNumberFormat.throwIfUnsupported();
        Object handle = FIXED_CONSTRUCTOR.invoke(content.getHandle());
        return new Fixed(handle);
    }

    public static Styled styled(@NotNull WrappedComponentStyle style) {
        WrappedNumberFormat.throwIfUnsupported();
        Object handle = STYLED_CONSTRUCTOR.invoke(style.getHandle());
        return new Styled(handle);
    }

    private static void throwIfUnsupported() {
        if (!WrappedNumberFormat.isSupported()) {
            throw new IllegalStateException("NumberFormat classes don't exist on this server version");
        }
    }

    private WrappedNumberFormat(Class<?> handleType) {
        super(handleType);
    }

    static {
        if (!WrappedNumberFormat.isSupported()) {
            BLANK = null;
            FIXED_CONSTRUCTOR = null;
            STYLED_CONSTRUCTOR = null;
        } else {
            Class<?> blankClass = MinecraftReflection.getBlankFormatClass().get();
            FuzzyReflection fuzzyBlank = FuzzyReflection.fromClass(blankClass, true);
            BLANK = Accessors.getFieldAccessor(fuzzyBlank.getFieldByType("INSTANCE", blankClass)).get(null);
            FIXED_CONSTRUCTOR = Accessors.getConstructorAccessor(MinecraftReflection.getFixedFormatClass().get(), MinecraftReflection.getIChatBaseComponentClass());
            STYLED_CONSTRUCTOR = Accessors.getConstructorAccessor(MinecraftReflection.getStyledFormatClass().get(), MinecraftReflection.getComponentStyleClass());
        }
    }

    public static class Blank
    extends WrappedNumberFormat {
        private Blank(Object handle) {
            super(MinecraftReflection.getBlankFormatClass().get());
            this.setHandle(handle);
        }
    }

    public static class Fixed
    extends WrappedNumberFormat {
        private final StructureModifier<Object> modifier;

        private Fixed(Object handle) {
            super(MinecraftReflection.getFixedFormatClass().get());
            this.setHandle(handle);
            this.modifier = new StructureModifier(handle.getClass()).withTarget(handle);
        }

        public WrappedChatComponent getContent() {
            Object handle = this.modifier.withType(MinecraftReflection.getIChatBaseComponentClass()).read(0);
            return WrappedChatComponent.fromHandle(handle);
        }
    }

    public static class Styled
    extends WrappedNumberFormat {
        private final StructureModifier<Object> modifier;

        private Styled(Object handle) {
            super(MinecraftReflection.getStyledFormatClass().get());
            this.setHandle(handle);
            this.modifier = new StructureModifier(handle.getClass()).withTarget(handle);
        }

        public WrappedComponentStyle getStyle() {
            Object handle = this.modifier.withType(MinecraftReflection.getComponentStyleClass()).read(0);
            return new WrappedComponentStyle(handle);
        }
    }
}

